const express = require('express');
const router = express.Router();
const controller = require('../controller/shipment.controller');
const authMiddleware = require('../core/utils/authMiddleware');
const authorize = require('../core/utils/authorize');

// Only Purchase can create shipment
router.post(
  '/create',
  authMiddleware,
  authorize(['Purchase']),
  controller.createShipment
);

router.post(
  '/container/planned',
  authMiddleware,
  authorize(['Purchase']),
  controller.createPlannedContainersBulk
);

router.patch(
  '/container/actual/:id',
  authMiddleware,
  authorize(['Purchase']),
  controller.addActualContainer
);

router.patch(
  "/container/payment/:id",
  authMiddleware,
  authorize(["FAS"]),
  controller.updateFASContainer
);


router.patch(
"/container/logistic/:id", 
authMiddleware,
authorize(["Logistic"]),
controller.updateLogisticsDetails
);

router.patch(
  "/container/clearence-payment/:id",
  authMiddleware,
  authorize(["FAS"]),
  controller.addContainerPayment
);

router.patch(
"/container/clearance/:id", 
authMiddleware,
authorize(["Logistic"]),
controller.clearContainer
);

router.patch(
  '/container/grn/:id',
  authMiddleware,
  authorize(['Purchase']),
  controller.addContainerGRN
);

router.get(
  '/',
  authMiddleware,
  authorize(['Purchase','FAS','Logistic']),
  controller.getAllShipments
);


router.get(
  '/dashboard',
  authMiddleware,
  authorize(['Purchase','FAS','Logistic']),
  controller.getShipmentSummary
);

router.get(
  '/:id',
  authMiddleware,
  authorize(['Purchase','FAS','Logistic']),
  controller.getShipmentById
);




module.exports = router;


