const express = require('express');
const router = express.Router();
const itemController = require('../controller/item.controller');
const authMiddleware = require('../core/utils/authMiddleware'); // JWT verification
const authorize = require('../core/utils/authorize'); // role-based access

// CREATE ITEM - Purchase or FAS only
router.post(
  '/create',
  authMiddleware,
  authorize(['Purchase','FAS']),
  itemController.createItem
);

// GET ITEMS - any role can see, with pagination
router.get(
  '/all',
  authMiddleware,
  authorize(['Purchase','FAS','Logistics','Manager','Admin']),
  itemController.getItems
);

module.exports = router;
