const mongoose = require('mongoose');

const itemSchema = new mongoose.Schema({
  itemCode: { type: String, unique:true, required:true },
  description: { type: String, required:true },
  packing: { type: String },
  bagWeightKg: { type: Number },
  unit: { type: String, default:"MT" },
  status: { type: String, enum:["Active","Inactive"], default:"Active" }
}, { timestamps:true });

module.exports = mongoose.model("Item", itemSchema);
